//
// Created by dave on 2012-05-21.
//

#import <Foundation/Foundation.h>

#define OPLoginFieldKeyName @"name"
#define OPLoginFieldKeyValue @"value"
#define OPLoginFieldKeyType @"type"
#define OPLoginFieldKeyHtmlId @"id"
#define OPLoginFieldKeyDesignation @"designation"

extern NSString *OPLoginFieldDesignationUsername;
extern NSString *OPLoginFieldDesignationPassword;

#define OPLoginFieldTypeText @"T"
#define OPLoginFieldTypePassword @"P"
#define OPLoginFieldTypeEmail @"E"
#define OPLoginFieldTypeURL @"U"
#define OPLoginFieldTypeNumber @"N"
#define OPLoginFieldTypeRadio @"R"
#define OPLoginFieldTypeTextArea @"A"
#define OPLoginFieldTypeButton @"B"
#define OPLoginFieldTypeCheckbox @"C"
#define OPLoginFieldTypeTelephone @"TEL"
#define OPLoginFieldTypeTextString @"S"

@interface OPLoginField : NSDictionary

@property (nonatomic) NSString *name;
@property (nonatomic) NSString *value;
@property (nonatomic) NSString *type;
@property (nonatomic) NSString *designation;
@property (readonly) NSString *htmlId;
@property (readonly) BOOL designatedAsUsername;
@property (readonly) BOOL designatedAsPassword;
@property (readonly) BOOL canConflict;
@property (readonly) BOOL isConcealed;
@property (readonly) BOOL isButton;
@property (readonly) BOOL isCheckbox;
@property (readonly) BOOL isRadio;
@property (readonly) BOOL isTextArea;

- (id)initWithDictionary:(NSDictionary *)fieldDefinition;
- (void)_removeDesignation;
- (NSMutableDictionary *)asDictionary;

- (NSString *)valueLimitedToLength:(NSInteger)length;

@end